IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Lotes_Asientos_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Cbtes_Lotes_Asientos_Generar 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Lotes_Asientos_Generar] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

DECLARE 	@pLote				VARCHAR(20),
			@pFecha_Desde		DATETIME,
			@pFecha_Hasta		DATETIME,
			@pTipo				CHAR(3),
			@pCriterio			CHAR(3),
			@pFlagUsarTrans		TINYINT,
			@pModoDebug			TINYINT

SET @pLote				= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJsonRecibido,'Lote')), '')
SET @pFecha_Desde		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Desde')),GETDATE())
SET @pFecha_Hasta		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Hasta')),GETDATE())
SET @pTipo				= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo')), '')
SET @pCriterio			= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Criterio')), '')
SET @pFlagUsarTrans		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

/* DECLARACION DE VARIABLES LOCALES */

DECLARE @JSON_Parametros_Stored_Invocado				VARCHAR(8000)
DECLARE @Result_Stored_Invocado							INT
DECLARE @Mensaje										VARCHAR(100)
DECLARE @UltError										INT
DECLARE @Segundos										INT
DECLARE @Cta_No_Definida								INT

DECLARE @Result_Tabla_Stored_Invocado TABLE (
											  ErrorNumber		INT,
											  ErrorSeverity		INT,
											  ErrorState		INT,
											  ErrorProcedure	VARCHAR(1000),
											  ErrorLine			INT,
											  ErrorMessage		VARCHAR(1000)
											)

CREATE TABLE #TRANS_TIPO ( Id_Trans INT )
CREATE TABLE #TRANS_CRITERIO ( Id_Trans INT )

/* FIN DECLARACION DE VARIABLES LOCALES */

IF(@pModoDebug = 1)
BEGIN
	PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Lotes_Asientos_Generar'
	PRINT 'Parametros:'
	PRINT '@pLote: ' + @pLote
	PRINT '@pFecha_Desde: ' + CONVERT(VARCHAR(30), @pFecha_Desde, 112)
	PRINT '@pFecha_Hasta: ' + CONVERT(VARCHAR(30), @pFecha_Hasta, 112)
	PRINT '@pTipo: ' + CONVERT(VARCHAR(5), @pTipo)
	PRINT '@pCriterio: ' + CONVERT(VARCHAR(5), @pCriterio)
	PRINT '@pFlagUsarTrans: ' + CONVERT(VARCHAR(5), @pFlagUsarTrans)
END

BEGIN TRY

	IF(ISNULL(dbo.CF_xParam('CtaNoDefinida'),0) = 0)
		RAISERROR ('Debe definir el parametro CtaNoDefinida', 16, 1)

	/* ---------------------------------------------------- POR PARAMETRO @pTipo ---------------------------------------------------- */
	IF(@pLote <> '')
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Genera por parametro @pLote'
		END

		INSERT INTO #TRANS_TIPO SELECT Id_Trans FROM Cbtes WHERE Lote = @pLote
	END
	ELSE IF(@pTipo <> '')
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Genera por parametro @pTipo - Filtra por Tipo de Cbte y Rango de Fechas'
		END

		INSERT INTO #TRANS_TIPO SELECT C.Id_Trans 
								  FROM Cbtes C
								  LEFT JOIN Cbtes_Tipos CT ON CT.Id_Tipo_Cbte = C.Id_Tipo_Cbte 
								  WHERE Fecha >= CONVERT(varchar(30),@pFecha_Desde,112)
										AND Fecha < CONVERT(varchar(30),DATEADD(DAY,1,@pFecha_Hasta),112)
										AND 1 = ABS(CASE 
							  						WHEN @pTipo = 'V' THEN CT.Compromete_Factura
							  						WHEN @pTipo = 'C' THEN CT.Compromete_Compras
							  						WHEN @pTipo = 'P' THEN CT.Compromete_Pagos
							  						WHEN @pTipo = 'R' THEN CT.Compromete_Recibos
							  						WHEN @pTipo = 'T' THEN CT.Compromete_Trans_Fondos
							  					END)

		END
	/* ---------------------------------------------------- FIN POR PARAMETRO @pTipo ---------------------------------------------------- */

	/* ---------------------------------------------------- POR PARAMETRO @pCriterio ---------------------------------------------------- */

	IF(@pCriterio = 'G' OR @pCriterio = 'E')
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Genera por @pCriterio General o Error'
		END

		/* AGREGO TRANSACCIONES SIN ASIENTOS */
		INSERT INTO #TRANS_CRITERIO SELECT Id_Trans FROM #TRANS_TIPO TT WHERE NOT EXISTS (SELECT ID_TRANS FROM Cbtes_Ctas_Contables CCC WHERE CCC.ID_TRANS = TT.Id_Trans)

		IF(@pCriterio = 'E')
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Filtra por @pCriterio Error'
			END

			/* AGREGO TRANSACCIONES CON CUENTA 'A IMPUTAR' */
			SET @Cta_No_Definida = dbo.CF_xParam('CtaNoDefinida')

			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Agrega Trans con Cuenta a Imputar (ALIAS: ' + CONVERT(VARCHAR(10),@Cta_No_Definida) + ')'
			END

			INSERT INTO #TRANS_CRITERIO SELECT Id_Trans FROM #TRANS_TIPO TT WHERE EXISTS (SELECT ID_TRANS FROM Cbtes_Ctas_Contables CCC WHERE CCC.ID_TRANS = TT.Id_Trans AND ALIAS = @Cta_No_Definida)

			/* AGREGO TRANSACCIONES CON ASIENTOS NO BALANCEADOS */
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Agrega Trans no balanceadas'
			END

			INSERT INTO #TRANS_CRITERIO SELECT TT.Id_Trans FROM #TRANS_TIPO TT LEFT JOIN Cbtes_Ctas_Contables CCC ON TT.Id_Trans = CCC.ID_TRANS
															    GROUP BY TT.ID_TRANS
															    HAVING (SUM(CCC.HABER) - SUM(CCC.DEBE)) <> 0

		END
	END
	ELSE IF(@pCriterio = 'R')
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Genera por @pCriterio Regenera'
		END
		INSERT INTO #TRANS_CRITERIO SELECT Id_Trans FROM #TRANS_TIPO
		DELETE FROM Cbtes_Ctas_Contables WHERE ID_TRANS IN (SELECT Id_Trans FROM #TRANS_TIPO)
	END
	/* ---------------------------------------------------- FIN POR PARAMETRO @pCriterio ---------------------------------------------------- */

	/* ------------------------------------------------------ CORRECCION DE ASIENTOS ------------------------------------------------------ */

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Realiza la correccion de asientos'
	END

	DECLARE @Id_Trans INT
	DECLARE curCPJAsientos CURSOR FOR
	SELECT Id_Trans FROM #TRANS_CRITERIO

	OPEN curCPJAsientos
	FETCH NEXT FROM curCPJAsientos INTO @Id_Trans
	WHILE @@FETCH_STATUS = 0
	BEGIN

		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Id_Trans: ' + CONVERT(VARCHAR(20),@Id_Trans)
		END

		SET @JSON_Parametros_Stored_Invocado =	'{' +
												dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
												dbo.CF_Json_ParsearVariable('ModoDebug', 0, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('FlagRegenerar', 1, 'TINYINT') + 
												'}'
				
		
		INSERT INTO @Result_Tabla_Stored_Invocado					
		EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ctas_Contables_Generar @JSON_Parametros_Stored_Invocado

		IF ISNULL(@Result_Stored_Invocado,0) <> 0 
		BEGIN
			INSERT INTO Cbtes_Lotes_Errores (Lote,Item,Id_Trans,Id_Cliente,Cod_Barra,Descripcion,Importe)
									VALUES (@pLote,1,@Id_Trans,0,'','Error desde CPJ_Cbtes_Lotes_Asientos_Generar',0)
			RETURN 9999
		END

	FETCH NEXT FROM curCPJAsientos INTO @Id_Trans
	END
	CLOSE curCPJAsientos
	DEALLOCATE curCPJAsientos

	/* ------------------------------------------------------ FIN CORRECCION DE ASIENTOS ------------------------------------------------------ */

	DROP TABLE #TRANS_TIPO
	DROP TABLE #TRANS_CRITERIO

END TRY  
BEGIN CATCH  
	IF EXISTS(SELECT * FROM @Result_Tabla_Stored_Invocado)
	BEGIN
		SELECT * FROM @Result_Tabla_Stored_Invocado
		EXECUTE usp_GetErrorInfo
		RETURN 9999
	END
END CATCH

RETURN 0

/*
MODO DE USO:

DECLARE @Param VARCHAR(5000) -- 10 seg x 4088 (calculo de casi 80000 transacciones -> 13 minutos)

SET @Param = '{' +
			'"Lote":"",' +
			'"Fecha_Desde":"20230701",' +
			'"Fecha_Hasta":"20230731",' +
			'"Tipo":"R",' +
			'"Criterio":"E",' +
			'"FlagUsarTrans":"0",' +
			'"ModoDebug":"1"' +
			'}'

EXEC CPJ_Cbtes_Lotes_Asientos_Generar @Param
*/